show databases;

#-- Change to other preferred database, if required
DROP database IF EXISTS elijay_community_hospital;
create database elijay_community_hospital;

use elijay_community_hospital;
	DROP TABLE IF EXISTS  PATIENT;
    DROP TABLE IF EXISTS  PERSONNEL;
    DROP TABLE IF EXISTS  PATIENT_PRESCRIPTION;
    DROP TABLE IF EXISTS  BED;
    DROP TABLE IF EXISTS  IN_PATIENT;
    DROP TABLE IF EXISTS  OUT_PATIENT;
    DROP TABLE IF EXISTS  TREATMENT;
    DROP TABLE IF EXISTS  TEST;
    DROP TABLE IF EXISTS  DEPARTMENT;
    DROP TABLE IF EXISTS  BILL;
 
#-------------------------------------------------------
#--  DDL for Table PATIENT
#-------------------------------------------------------
CREATE TABLE PATIENT(
		PATIENTID BIGINT PRIMARY KEY,
		NAME VARCHAR(100),
        DOB VARCHAR(20),
        AGE INT,
        GENDER CHAR(10),
        ADDRESS VARCHAR(200),
        EMAIL VARCHAR(100),
        PHONE VARCHAR(50)
);

#-------------------------------------------------------
#--  DDL for Table PERSONNEL
#-------------------------------------------------------
CREATE TABLE PERSONNEL(
		PERSONNEL_ID BIGINT PRIMARY KEY,
		NAME VARCHAR(100),
        PHONE VARCHAR(50),
        EMAIL VARCHAR(100),
        ADDRESS VARCHAR(200),
        HIREDATE VARCHAR(20),
        POSITION VARCHAR(40),
        DEPARTMENTCODE VARCHAR(20)
);

#-------------------------------------------------------
#--  DDL for Table PATIENT_PRESCRIPTION
#-------------------------------------------------------
CREATE TABLE PATIENT_PRESCRIPTION(
		CONSULTATION_ID BIGINT,
        PATIENTID BIGINT,
        PERSONNELID BIGINT,
        DATE VARCHAR(20),
        TESTCODE VARCHAR(20),
        TREATMENTCODE VARCHAR(20),
        COMMENTS  VARCHAR(200)
); 

#-------------------------------------------------------
#--  DDL for Table BED
#-------------------------------------------------------
CREATE TABLE BED(
		ROOMNUMBER INT,
        ROOMTYPE VARCHAR(20),
        BEDNUMBER INT
);

#-------------------------------------------------------
#--  DDL for Table IN-PATIENT
#-------------------------------------------------------
CREATE TABLE IN_PATIENT(
		CONSULTATION_ID BIGINT,
        PATIENTID BIGINT,
        DATE_OF_ADMISSION VARCHAR(20),
        ROOMNUMBER INT,
        BEDNUMBER INT,
        DATE_OF_DISCHARGE VARCHAR(20)
);

#-------------------------------------------------------
#--  DDL for Table OUT-PATIENT
#-------------------------------------------------------
CREATE TABLE OUT_PATIENT(
		CONSULTATION_ID BIGINT,
        PATIENTID BIGINT
);

#-------------------------------------------------------
#--  DDL for Table TREATMENT
#-------------------------------------------------------
CREATE TABLE TREATMENT(
		TREATMENTCODE VARCHAR(20) PRIMARY KEY,
        TREATMENTDESCRIPTION VARCHAR(300),
        TREATMENTCOST BIGINT
);

#-------------------------------------------------------
#--  DDL for Table TEST
#-------------------------------------------------------
CREATE TABLE TEST(
		TESTCODE VARCHAR(20) PRIMARY KEY,
        TESTDESCRIPTION VARCHAR(300),
        TESTCOST BIGINT
);

#-------------------------------------------------------
#--  DDL for Table DEPARTMENT
#-------------------------------------------------------
CREATE TABLE DEPARTMENT(
		DEPARTMENTCODE VARCHAR(20) PRIMARY KEY,
        DEPARTMENTNAME VARCHAR(50)
);

#-------------------------------------------------------
#--  DDL for Table BILL
#-------------------------------------------------------
CREATE TABLE BILL(
		BILL_ID BIGINT,
        CONSULTATION_ID BIGINT,
        AMOUNT BIGINT
);

show tables;

# INSERTING into PATIENT
Insert into PATIENT (PATIENTID,NAME,DOB,AGE,GENDER,ADDRESS,EMAIL,PHONE) values (1,'Patient 1','2000-01-01',21,'M','132-My Street, Kingston, New York, 12401','patient1@gmail.com;patient001@gmail.com','+16469804796;+16469806809');
Insert into PATIENT (PATIENTID,NAME,DOB,AGE,GENDER,ADDRESS,EMAIL,PHONE) values (2,'Patient 2','2005-01-01',16,'F','Oakland Ave, A City, Florida, 32104','patient2@gmail.com;','+19078583540;');

# INSERTING into PERSONNEL
Insert into PERSONNEL (PERSONNEL_ID,NAME,PHONE,EMAIL,ADDRESS,HIREDATE,POSITION,DEPARTMENTCODE) values (1,'Doctor 1','+16469811196;+16469811026','doc1@gmail.com;','100-XYZ Street, Kingston, New York, 12401','1995-01-01','ORTHOPAEDICS','D-001');
Insert into PERSONNEL (PERSONNEL_ID,NAME,PHONE,EMAIL,ADDRESS,HIREDATE,POSITION,DEPARTMENTCODE) values (2,'Doctor 2','+16469800011;+16469811000','doc2@gmail.com;','12-ABC Street, Kingston, New York, 12401','2000-01-01','ORTHOPAEDICS','D-001');

# INSERTING into BED
Insert into BED (ROOMNUMBER,ROOMTYPE,BEDNUMBER) values (100,'WARD1',1);
Insert into BED (ROOMNUMBER,ROOMTYPE,BEDNUMBER) values (100,'WARD1',2);

# INSERTING into IN PATIENT
Insert into IN_PATIENT (CONSULTATION_ID,PATIENTID, DATE_OF_ADMISSION,ROOMNUMBER,BEDNUMBER,DATE_OF_DISCHARGE) values (10000001,1,'2021-01-10',100,1,'2021-01-15');

# INSERTING into OUT PATIENT
Insert into OUT_PATIENT (CONSULTATION_ID,PATIENTID) values (10000002,2);

# INSERTING into TREATMENT
Insert into TREATMENT (TREATMENTCODE,TREATMENTDESCRIPTION,TREATMENTCOST) values ('TR-001','PHYSIOTHERAPY',1500);
Insert into TREATMENT (TREATMENTCODE,TREATMENTDESCRIPTION,TREATMENTCOST) values ('TR-002','RADIOLOGY',1000);
Insert into TREATMENT (TREATMENTCODE,TREATMENTDESCRIPTION,TREATMENTCOST) values ('TR-003','CARDIAC REHAB',5000);

# INSERTING into TEST
Insert into TEST (TESTCODE,TESTDESCRIPTION,TESTCOST) values ('TE-001','HRCT SCAN',1000);
Insert into TEST (TESTCODE,TESTDESCRIPTION,TESTCOST) values ('TE-002','X-RAY',750);
Insert into TEST (TESTCODE,TESTDESCRIPTION,TESTCOST) values ('TE-003','CRC TEST',350);
Insert into TEST (TESTCODE,TESTDESCRIPTION,TESTCOST) values ('TE-004','HAEMOGLOBIN TEST',250);

# INSERTING into DEPARTMENT
Insert into DEPARTMENT (DEPARTMENTCODE,DEPARTMENTNAME) values ('D-001','PHYSIO');
Insert into DEPARTMENT (DEPARTMENTCODE,DEPARTMENTNAME) values ('D-002','CARDIO');
Insert into DEPARTMENT (DEPARTMENTCODE,DEPARTMENTNAME) values ('D-003','GASTRO');

# INSERTING into BILL
Insert into BILL (BILL_ID,CONSULTATION_ID,AMOUNT) values (1,10000001,1750);
Insert into BILL (BILL_ID,CONSULTATION_ID,AMOUNT) values (2,10000002,350);

# INSERTING into PATIENT_PRESCRIPTION
Insert into PATIENT_PRESCRIPTION (CONSULTATION_ID,PATIENTID, PERSONNELID, DATE,TESTCODE,TREATMENTCODE,COMMENTS) values (10000001,1,1,'2021-01-10','TE-002','TR-001','');
Insert into PATIENT_PRESCRIPTION (CONSULTATION_ID,PATIENTID, PERSONNELID, DATE,TESTCODE,TREATMENTCODE,COMMENTS) values (10000001,1,1,'2021-01-10','TE-001','TR-001','');
Insert into PATIENT_PRESCRIPTION (CONSULTATION_ID,PATIENTID, PERSONNELID, DATE,TESTCODE,TREATMENTCODE,COMMENTS) values (10000002,2,2,'2021-01-10','TE-003','','');

# Queries
select * from patient;
select * from personnel;
select * from patient_prescription;
select * from bed;
select * from in_patient;
select * from out_patient;
select * from bed;
select * from department;
select * from test;
select * from treatment;
